﻿using System.Collections.Generic;
using System.Text;
using System.Web.UI.WebControls;

using VIRP.EFR.BO;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class AddressEntry : System.Web.UI.UserControl
    {
        public void PopulatePCPInfo(Address pcpInfo)
        {
            PopulateAddressInfo(pcpInfo, PCPInfoLabel, hdfPCPInfoField);
        }

        public void PopulateVAMCInfo(Address vamcInfo)
        {
            PopulateAddressInfo(vamcInfo, VAMCInfoLabel, hdfVAMCInfoField);
        }

        public void PopulatePrimaryAddressInfo(Address address)
        {
            PopulateAddressInfo(address, PrimaryAddressLabel, hdfPrimaryAddress);
        }

        public void PopulateSecondaryAddressInfo(Address address)
        {
            PopulateAddressInfo(address, AlternateAddressLabel, hdfAlternateAddress);
        }

        private string FieldName(string input, string alt)
        {
            return !string.IsNullOrEmpty(input) ? input : alt;
        }

        private void PopulateAddressInfo(Address address, Label label, HiddenField hiddenField)
        {
            if (address == null || label == null || hiddenField == null)
                return;

            StringBuilder sb = new StringBuilder();
            List<string> fields = new List<string>();

            if (!string.IsNullOrEmpty(address.Name))
            {
                sb.Append(address.Name);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.Name, "Name"));

            if (!string.IsNullOrEmpty(address.Facility))
            {
                sb.Append(address.Facility);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.Facility, "FacilityName"));

            if (!string.IsNullOrEmpty(address.AddressPart1))
            {
                sb.Append(address.AddressPart1);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.AddressPart1, "AddressPart1"));

            if (!string.IsNullOrEmpty(address.AddressPart2))
            {
                sb.Append(address.AddressPart2);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.AddressPart2, "AddressPart2"));

            if (!string.IsNullOrEmpty(address.AddressPart3))
            {
                sb.Append(address.AddressPart3);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.AddressPart3, "AddressPart3"));

            if (!string.IsNullOrEmpty(address.City))
            {
                sb.Append(address.City + ", " + address.State + " " + address.Zip);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.City, "City"));
            fields.Add(FieldName(address.State, "State"));
            fields.Add(FieldName(address.Zip, "Zip"));

            if (!string.IsNullOrEmpty(address.Country))
            {
                sb.Append(address.Country);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.Country, "Country"));

            if (!string.IsNullOrEmpty(address.Phone))
            {
                sb.Append(address.Phone);
                sb.Append("<br/>");
            }
            fields.Add(FieldName(address.Phone, "Phone"));

            hiddenField.Value = string.Join("|", fields.ToArray());
            label.Text = sb.ToString();
        }

        public void PopulateAddress(Address addr)
        {
            txtName.Text = addr.Name;
            lblName.Text = addr.Name;
            txtAddressPart1.Text = addr.AddressPart1;
            txtAddressPart2.Text = addr.AddressPart2;
            txtAddressPart3.Text = addr.AddressPart3;
            txtCity.Text = addr.City;
            txtState.Text = addr.State;
            txtCountry.Text = addr.Country;
            txtPhone.Text = addr.Phone;
            txtZip.Text = addr.Zip;
            txtFacilityName.Text = addr.Facility;
        }

        public Address GetAddress()
        {
            Address Addr = new Address();
            Addr.Name = txtName.Text;
            if (string.IsNullOrEmpty(txtAddressPart1.Text))
                Addr.AddressPart1 = null;
            else
                Addr.AddressPart1 = txtAddressPart1.Text;
            if (string.IsNullOrEmpty(txtAddressPart2.Text))
                Addr.AddressPart2 = null;
            else
                Addr.AddressPart2 = txtAddressPart2.Text;
            if (string.IsNullOrEmpty(txtAddressPart3.Text))
                Addr.AddressPart3 = null;
            else
                Addr.AddressPart3 = txtAddressPart3.Text;
            if (string.IsNullOrEmpty(txtCity.Text))
                Addr.City = null;
            else
                Addr.City = txtCity.Text;
            if (string.IsNullOrEmpty(txtState.Text))
                Addr.State = null;
            else
                Addr.State = txtState.Text;
            if (string.IsNullOrEmpty(txtCountry.Text))
                Addr.Country = null;
            else
                Addr.Country = txtCountry.Text;
            if (string.IsNullOrEmpty(txtPhone.Text))
                Addr.Phone = null;
            else
                Addr.Phone = txtPhone.Text;
            if (string.IsNullOrEmpty(txtZip.Text))
                Addr.Zip = null;
            else
                Addr.Zip = txtZip.Text;

            if (string.IsNullOrEmpty(txtFacilityName.Text))
                Addr.Facility = null;
            else
                Addr.Facility = txtFacilityName.Text;
            return Addr;
        }

        public bool NameReadOnly
        {
            set
            {
                if (value == true)
                {
                    txtName.Visible = false;
                    lblName.Visible = true;

                    label14.AssociatedControlID = lblName.ID;
                }
                else
                {
                    txtName.Visible = true;
                    lblName.Visible = false;
                    label14.SkinID = "";
                    label14.AssociatedControlID = txtName.ID;
                }
            }
        }

        public bool ShowFacilityBoxAndPCPVAMCPanels
        {
            set
            {
                labelFacilityName.Visible = txtFacilityName.Visible = value;
                PCPInfoPanel.Visible = VAMCInfoPanel.Visible = value;
            }
        }

        public bool ShowPrimaryAlternateAddressPanels
        {
            set
            {
                PrimaryAddressPanel.Visible = AlternateAddressPanel.Visible = value;
            }
        }

        public string GroupingText
        {
            set
            {
                InterpretationSectionPanel.GroupingText = value;
            }
        }
        protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
        {
            if (txtAddressPart1.Text.Trim() == "" 
                && (txtAddressPart2.Text.Trim() != "" 
                    || txtAddressPart3.Text.Trim() != "" 
                    || txtCity.Text.Trim() != "" 
                    || txtState.Text.Trim() != "" 
                    || txtCountry.Text.Trim() != "" 
                    || txtZip.Text.Trim() != "" 
                    || txtPhone.Text.Trim() != ""))
            {
                args.IsValid = false;
            }
        }
    }
}
